<?php

namespace App\Http\Controllers;
use DB;
use App\Quotation;
use Illuminate\Http\Request;
use App\Patients;
use App\Doctors;
use Session;
use App\Questionnaire;
use Illuminate\Support\Facades\Auth;
use Redirect;
use Carbon\Carbon;
use PDF;
use ZipArchive;
use Illuminate\Support\Str;
use Mpdf\Mpdf;
use Image;
use Illuminate\Support\Facades\File;
use Webklex\IMAP\Facades\Client;
class ProjectController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    
    
    
    public function viewProjects(Request $request)
    {
        $projects = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->leftjoin('project_types as d', 'a.project_type', '=', 'd.id')
            ->select('a.*', 'b.company_name', 'c.name as status', 'd.name as type')
            ->orderBy('id', 'desc')
            ->get();
        
        foreach($projects as $project){
            $current = DB::table('project_status_history')->where('project_id', $project->id)->where('status_id', $project->project_status)->orderBy('id', 'desc')->limit(1)->first();
            if($current){
                $project->end_date = $current->end_date;
            }else{
                $project->end_date = "";
            }
        }
        
        $projects = $projects->sortBy(function($project) {
            return $project->end_date ? strtotime($project->end_date) : PHP_INT_MAX;
        });
        
        $project_types = DB::table('project_types')->orderBy('name', 'asc')->get();
        $statusses = DB::table('project_statuses')->orderBy('name', 'asc')->get();
        $customers = DB::table('customers')->orderBy('id', 'asc')->get();
        
        //$customer = DB::table('customers')->where('id', $id)->first();
        return view('project.projects', ['projects' => $projects, 'project_types' => $project_types, 'statusses' => $statusses, 'customers'=>$customers]);
    }
    
    
    
    
    public function exportImages(Request $request, $id)
    {
        
        $before_images = explode(',', $request->before_images);
        $first_site = explode(',', $request->first_site);
        
        
        
        $beforeArray = array();
        $firstSiteArray = array();
        
        if(!empty($request->before_images)){
            foreach($before_images as $bi){
                $image = DB::table('project_images')->where('id', $bi)->first();
                if(isset($image->file)){
                    $beforeArray[] = asset('img/projects/'.$image->file);
                }
            }
        }
        
        if(!empty($request->first_site)){
            foreach($first_site as $fs){
                $image = DB::table('project_images')->where('id', $fs)->first();
                if(isset($image->file)){
                    $firstSiteArray[] = asset('img/projects/'.$image->file);
                }
            }
        }
        
        
        $project = DB::table('projects')->where('id', $id)->first();
        
        /*$options = new Options();
        $options->set('isPhpEnabled', true);
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isRemoteEnabled', true);*/
        
        $mpdf = new Mpdf([
            'tempDir' => storage_path('/tmp'),
            'mode' => 'utf-8',
            'format' => 'A4'
        ]);

        // Start buffer
        ob_start();
        $max_per_page = $request->images_per_screen;

// HTML content to be rendered into PDF
$html = '<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>mPDF Example</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
    }
    table {
      width: 100%;
      border-collapse: collapse;
    }
    table td {
      padding: 5px;
      text-align: center;
    }
    table img {
      width: 100%;
      height: 250px;
    }
  </style>
</head>
<body>';
        
$html .= '<div style="position:absolute;right:20px"><img width="150px" src="'.asset('img/walker.png').'"></div><center><h1>Image Report<br><span style="font-size:14px">'.date('d F Y').'</span></h1></center>';
        
$html .= '<p><b>Project ID: WG-'.str_pad($project->id, 4, '0', STR_PAD_LEFT).'</b> <br>
<b>Customer Location: Grosvenor Waterside, London</b>
<br>
</p>';

// Loop through $beforeArray and create pages dynamically
$total_images = count($beforeArray);
$start_index = 0;

while ($start_index < $total_images) {
    $end_index = $start_index + $max_per_page;
    $chunk = array_slice($beforeArray, $start_index, $max_per_page);
    $html .= '<h2 style="text-align:center">Before</h2>';
    $html .= '<table>';
    foreach (array_chunk($chunk, 3) as $row) {
        $html .= '<tr>';
        foreach ($row as $image) {
            $html .= '<td width="33%"><img style="margin-bottom:25px;margin-top:25px;width:250px;height:250px" src="' . $image . '" alt="Image"><p style="font-size:15px;margin-top:20px;margin-bottom:20px;">Location: 67 Grosvenor St, London<br>Date and Time: '.date('F d, Y h:ia').'</p></td>';
        }
        // Fill remaining cells if less than 3 images in the last row
        $num_cells = count($row);
        if ($num_cells < 3) {
            $remaining_cells = 3 - $num_cells;
            for ($i = 0; $i < $remaining_cells; $i++) {
                $html .= '<td></td>'; // Add empty TDs for missing images
            }
        }
        $html .= '</tr>';
    }
    $html .= '</table>';
    
    // Add page break after each set of 9 images
    if ($end_index < $total_images) {
        $html .= '<div style="page-break-after: always;"></div>';
    }
    
    $start_index = $end_index;
}
        
        
$total_images = count($firstSiteArray);
$start_index = 0;

while ($start_index < $total_images) {
    $end_index = $start_index + $max_per_page;
    $chunk = array_slice($firstSiteArray, $start_index, $max_per_page);
    if(!empty($beforeArray)){
        $html .= '<div style="page-break-after: always;"></div>';
    }
    $html .= '<h2 style="text-align:center">1st Site Visit</h2>';
    $html .= '<table>';
    foreach (array_chunk($chunk, 3) as $row) {
        $html .= '<tr>';
        foreach ($row as $image) {
            $html .= '<td width="33%"><img style="margin-bottom:25px;margin-top:25px;width:250px;height:250px" src="' . $image . '" alt="Image"><p style="font-size:15px;margin-top:20px;margin-bottom:20px;">Location: 67 Grosvenor St, London<br>Date and Time: '.date('F d, Y h:ia').'</p></td>';
        }
        // Fill remaining cells if less than 3 images in the last row
        $num_cells = count($row);
        if ($num_cells < 3) {
            $remaining_cells = 3 - $num_cells;
            for ($i = 0; $i < $remaining_cells; $i++) {
                $html .= '<td></td>'; // Add empty TDs for missing images
            }
        }
        $html .= '</tr>';
    }
    $html .= '</table>';
    
    // Add page break after each set of 9 images
    if ($end_index < $total_images) {
        $html .= '<div style="page-break-after: always;"></div>';
    }
    
    $start_index = $end_index;
}

$html .= '</body></html>';

        // Get buffer content and clean buffer
        //$html = ob_get_clean();

        // Write PDF content
        $mpdf->WriteHTML($html);

        // Output PDF to browser or download
        $mpdf->Output('project-report.pdf', 'D'); // D = download, I = inline

        exit;
        
    }
    
    
    
    
    
    public function addNewProject(Request $request)
    {
        $response = array();
        
        $this->validate($request, [
            'project_type'   =>   'required|int',
            'project_status'   =>   'required|int',
            'email'   =>   'required|string',
            'name'   =>   'required|string',
            'customer_id'   =>   'required|int',
        ]);
        
        $uniqid = substr(Str::upper(Str::random(3)), 0, 3) . '-' . substr(Str::upper(Str::random(3)), 0, 3);
        
        $projectid = DB::table('projects')->insertGetId(
             array(
                    'customer_id'   =>   $request->customer_id,
                    'customer_name'   =>   $request->name,
                    'customer_email'   =>   $request->email,
                    'customer_phone'   =>   $request->phone,
                    'customer_ref'   =>   $request->customer_ref,
                    'project_type'   =>   $request->project_type,
                    'project_status'   =>   $request->project_status,
                    'image' => 'placeholder.jpg',
                    'created_at' => date('Y-m-d H:i'),
                    'project_id' => $uniqid,
             )
        );
        
        $status = DB::table('project_statuses')->where('id', $request->project_status)->first();
        
        DB::table('project_status_history')->insertGetId(
             array(
                    'project_id'   =>   $projectid,
                    'status_id'   =>   $request->project_status,
                    'start_date'   =>   date('Y-m-d H:i'),
                    'end_date'   =>   Carbon::now()->addDays($status->completion_days)->toDateString(),
             )
        );
        
        $milestones = DB::table('project_milestones')
            ->where('project_type_id', $request->project_type)
            ->orderBy('sort', 'asc')
            ->get();
        if($milestones){
            foreach($milestones as $milestone){
                DB::table('milestones')->insertGetId(
                     array(
                            'milestone_id'   =>   $milestone->id,
                            'project_id'   =>   $projectid,
                            'milestone_name'   =>   $milestone->name,
                     )
                );
            }
        }
        
        $request->session()->flash('success', 'Project added successfully.');
        return redirect()->back();
    }
    
    
    public function showMilestones(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $milestones = DB::table('milestones as a')
            ->leftjoin('users as b', 'a.completed_by', '=', 'b.id')
            ->select('a.*', 'b.firstname', 'b.lastname')
            ->where('a.project_id', $request->id)
            ->get();
        
        $project_milestones = DB::table('project_milestones')->where('project_type_id', $project->project_type)->get();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.milestones', ['customer' => $customer, 'project' => $project, 'milestones' => $milestones, 'project_milestones'=>$project_milestones]);
    }
    
    
    public function showCorrespondence(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $correspondence = DB::table('correspondence')->where('project_id', $project->id)->get();
        $users = DB::table('users')->where('role', 'user')->get();
        return view('project.correspondence', ['customer' => $customer, 'project' => $project, 'users'=>$users, 'correspondence'=>$correspondence]);
    }
    
    public function showEmails(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $emails = DB::table('project_emails')->where('project_id', $project->id)->orderBy('id', 'desc')->get();
        $users = DB::table('users')->where('role', 'user')->get();
        
        
        
        
        
        return view('project.emails', ['customer' => $customer, 'project' => $project, 'users'=>$users, 'emails'=>$emails]);
    }
    
    
    public function showDocuments(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $documents = DB::table('project_documents')
            ->where('project_id', $request->id)
            ->orderBy('favourite', 'desc')
            ->orderBy('id', 'desc')
            ->get();
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.documents', ['customer' => $customer, 'project' => $project,  'documents'=>$documents]);
    }
    
    
    public function showImages(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'before')
            ->orderBy('id', 'desc')
            ->get();
        
        $first_site_visit = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', '1st_site_visit')
            ->orderBy('id', 'desc')
            ->get();
        
        $during = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'during')
            ->orderBy('id', 'desc')
            ->get();
        
        $completed = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'project_completed')
            ->orderBy('id', 'desc')
            ->get();
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'first_site_visit'=>$first_site_visit, 'during'=>$during, 'completed'=>$completed]);
    }
    
    
    public function showBeforeImages(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'before')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'Before']);
    }
    
    public function showFirstSiteImages(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', '1st_site_visit')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'First Site']);
    }
    
    public function showDuringImages(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'during')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'During']);
    }
    
    public function showCompletedImages(Request $request)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $request->id)
            ->first();
        
        $before_images = DB::table('project_images')
            ->where('project_id', $request->id)
            ->where('type', 'project_completed')
            ->orderBy('id', 'desc')
            ->get();
        
        
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        return view('project.all_images', ['customer' => $customer, 'project' => $project,  'before_images'=>$before_images, 'type'=>'Project Completed']);
    }
    
    
    public function uploadDocument(Request $request, $id)
    {
        $request->validate([
            'file' => 'required|mimes:jpeg,png,jpg,gif,pdf,doc,docx,xls,xlsx,ppt,pptx,txt,zip|max:2048',
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('documents'), $filename);
            $added = date('Y-m-d H:i');
            $fileid = DB::table('project_documents')->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'name'   =>   $name,
                        'file'   =>   $filename,
                        'created_at'   =>   $added,
                        'type'   =>   $ext,
                 )
            );

            
            $response = array();
            $response['filename'] = $filename;
            $response['name'] = $name;
            $response['type'] = $ext;
            $response['created_at'] = $added;
            $response['file_id'] = $fileid;
            return response()->json(['success' => $response]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }
    
    
    public function updateImage(Request $request)
    {
        $request->validate([
            'image' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/projects'), $filename);
            $added = date('Y-m-d H:i');
            $fileid = DB::table('project_images')->where('id', $request->image_id)->update(
                 array(
                        'name'   =>   $name,
                        'file'   =>   $filename,
                        'small_file'   =>   $filename,
                        'type'   =>   $request->type,
                 )
            );
            
            $request->session()->flash('success', 'Image updated successfully.');
            return redirect()->back();
        }

    }
    
    
    public function uploadProjectImages(Request $request, $id)
    {
        $request->validate([
            'file' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/projects'), $filename);
            $added = date('Y-m-d H:i');
            
            // Create an Intervention Image instance
            $image = public_path('img/projects/'.$filename);
            $img = Image::make($image);
            $quality = 25; // Example quality setting

            // Define the path to save the image
            $destinationPath = public_path('/img/projects/small');
            $imageName = uniqid(time()).'.'.$ext;

            // Save the image
            $img->save($destinationPath.'/'.$imageName, $quality);
            
            $fileid = DB::table('project_images')->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'name'   =>   $name,
                        'file'   =>   $filename,
                        'small_file' => $imageName,
                        'created_at'   =>   $added,
                        'type'   =>   $request->images_type,
                 )
            );
            
            $response = array();
            return response()->json(['success' => 1]);
        }

        return response()->json(['error' => 'No file uploaded'], 400);
    }
    
    
    public function uploadImage(Request $request, $id)
    {
        $request->validate([
            'image' => 'required|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $file->move(public_path('img/projects'), $filename);
            $added = date('Y-m-d H:i');
            DB::table('projects')->where('id', $id)->update(
                 array(
                        'image'   =>   $filename,
                 )
            );
            
            $request->session()->flash('success', 'Image updated successfully.');
            return redirect()->back();
            
        }
    }
    
    
    public function addToFavourites(Request $request)
    {
        $status = 0;
        $project = DB::table('projects')->where('id', $request->project_id)->first();
        
        if($project->favourite==1){
            $status = 0;
            $message = 'Project removed to favorites';
        }else{
            $status = 1;
            $message = 'Project added to favorites';
        }
        
        DB::table('projects')->where('id', $request->project_id)->update(
             array(
                    'favourite'   =>   $status,
             )
        );

        return response()->json(['success' => true, 'message' => $message, 'status' =>$status]);
    }
    
    
    public function bookmarkDocument(Request $request)
    {
        $status = 0;
        $document = DB::table('project_documents')->where('id', $request->document_id)->first();
        
        if($document->favourite==1){
            $status = 0;
            $message = 'Document removed to favorites';
        }else{
            $status = 1;
            $message = 'Document added to favorites';
        }
        
        DB::table('project_documents')->where('id', $request->document_id)->update(
             array(
                    'favourite'   =>   $status,
             )
        );

        return response()->json(['success' => true, 'message' => $message, 'status' =>$status]);
    }
    
    
    public function addMilestone(Request $request, $id)
    {
        DB::table('milestones')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'milestone_id'   =>   $request->milestone_id,
             )
        );
        
        $request->session()->flash('success', 'Milestone added successfully.');
        return redirect()->back();
    }
    
    public function addCorrespondence(Request $request, $id)
    {
        
        $correspondence_id = DB::table('correspondence')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'title'   =>   $request->title,
                    'notes'   =>   $request->notes,
                    'created_at'   =>   date('Y-m-d H:i'),
             )
        );
        
        foreach($request->users as $user){
            DB::table('correspondence_users')->insertGetId(
                 array(
                        'correspondence_id'   =>   $correspondence_id,
                        'user_id'   =>   $user,
                 )
            );
        }
        
        $request->session()->flash('success', 'Correspondence added successfully.');
        return redirect()->back();
    }
    
    
    public function addFinancials(Request $request, $id)
    {
        $added_ids = array();
        foreach($request->items as $item){
            
            $financial = DB::table('financial_items')->where('id', $item)->first();
            if($financial){
                $financialid = DB::table('project_financials')->insertGetId(
                     array(
                            'code'   =>   $financial->code,
                            'description'   =>   $financial->description,
                            'item_id'   =>   $item,
                            'sales_price'   =>   $financial->sales_price,
                            'uom'   =>   $financial->uom,
                            'project_id'   =>   $id,
                            'quantity'   =>   $financial->quantity,
                     )
                );   
                
                $added_ids[] = $financialid;
            }
        }
        
        $request->session()->flash('success', 'Financials added successfully.');
        return redirect()->back()->with('added_ids', $added_ids);
    }
    
    
    public function saveDocumentNotes(Request $request)
    {
        DB::table('project_documents')->where('id', $request->file_id)->update(
             array(
                   'notes'   =>   $request->notes,
             )
        );
        
        $document = DB::table('project_documents')->where('id', $request->file_id)->first();
        
        $response = array();
        $response['filename'] = $document->file;
        $response['name'] = $document->name;
        $response['type'] = $document->type;
        $response['created_at'] = date('jS M Y h:ia', strtotime($document->created_at));
        $response['file_id'] = $document->id;
        $response['notes'] = $document->notes;
        return response()->json(['success' => $response]);
    }
    
    
    public function completeMilestone(Request $request)
    {
        DB::table('milestones')
            ->where('milestone_id', $request->milestone_id)
            ->where('project_id', $request->project_id)
            ->update(
             array(
                    'completed'   =>   1,
                    'completed_by'   =>   Auth::id(),
                    'completion_date'   =>   date('Y-m-d H:i'),
                    
             )
        );
        
        $request->session()->flash('success', 'Milestone completed successfully.');
        return redirect()->back();
    }
    
    
    public function upliftFinancials(Request $request, $id)
    {
        $percentage = $request->uplift_percentage;
        $financials = DB::table('project_financials')->where('project_id', $id)->where('invoiced', 0)->get();
        foreach($financials as $financial){
            $sales_price = $financial->sales_price;
            $updated = ($sales_price) * ($percentage / 100);
            $total = $sales_price+$updated;
            DB::table('project_financials')
                ->where('id', $financial->id)
                ->where('project_id', $id)
                ->update(
                 array(
                        'sales_price'   =>   $total,
                 )
            );
        }
        
        $request->session()->flash('success', 'Financials uplifted successfully.');
        return redirect()->back();
    }
    
    
    public function updateDocumentNotes(Request $request)
    {
        DB::table('project_documents')
            ->where('id', $request->document_id)
            ->update(
             array(
                    'notes'   =>   $request->notes,
             )
        );
        
        $request->session()->flash('success', 'Notes updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateDocumentAccess(Request $request)
    {
        if(isset($request->employee_access)){
            DB::table('project_documents')
                ->where('id', $request->document_id)
                ->update(
                 array(
                        'employee_access'   =>   1,
                 )
            );
        }else{
            DB::table('project_documents')
                ->where('id', $request->document_id)
                ->update(
                 array(
                        'employee_access'   =>   0,
                 )
            );
        }
        
        
        $request->session()->flash('success', 'Access updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateMilestoneNotes(Request $request)
    {
        DB::table('milestones')
            ->where('id', $request->milestone_id)
            ->where('project_id', $request->project_id)
            ->update(
             array(
                    'notes'   =>   $request->notes,
             )
        );
        
        $request->session()->flash('success', 'Notes updated successfully.');
        return redirect()->back();
    }
    
    public function deleteDocument(Request $request)
    {
        $document = DB::table('project_documents')->where('id', $request->document_id)->first();
        if($document){
            $filePath = public_path('documents/'.$document->file);

            if (File::exists(public_path($filePath))) {
                File::delete(public_path($filePath));
            } 
        }
        
        DB::table('project_documents')->where('id', $request->document_id)->delete();
        $request->session()->flash('success', 'Document removed successfully.');
        return redirect()->back();
    }
    
    
    public function deleteImage(Request $request)
    {
        $image = DB::table('project_images')->where('id', $request->image_id)->first();
        if($image){
            $filePath = public_path('img/projects/'.$image->file);

            if (File::exists(public_path($filePath))) {
                File::delete(public_path($filePath));
            } 
        }
        
        DB::table('project_images')->where('id', $request->image_id)->delete();
        $request->session()->flash('success', 'Image removed successfully.');
        return redirect()->back();
    }
    
    
    public function assignManager(Request $request, $id)
    {
        if($request->manager_type=='Contracts'){
            $type = 'Contracts';
            DB::table('projects')->where('id', $id)->update(
                 array(
                        'contracts_manager'   =>   $request->manager_id,
                 )
            );
        }else{
            $type = 'Site';
            DB::table('projects')->where('id', $id)->update(
                 array(
                        'site_manager'   =>   $request->manager_id,
                 )
            );
        }
        
        
        if($request->manager_id!=Auth::id()){
            $title = 'Project Assigned';
            $description = 'You are assigned as '.$type.' manager for the Project ID: WG-'.str_pad($id, 4, '0', STR_PAD_LEFT);

            DB::table('notifications')->insert(
                 array(
                        'user_id'   =>   $request->manager_id,
                        'title'   =>   $title,
                        'description'   =>   $description,
                        'created_at'   =>   date('Y-m-d H:i'),
                        'link'   =>   'project/'.$id,
                 )
            );
        }
        
        
        
        /*DB::table('project_managers')->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'staff_id'   =>   $request->manager_id,
                    'type'   =>   $request->manager_type,
                    'assign_date' => date('Y-m-d H:i'),
             )
        );*/
        $request->session()->flash('success', 'Assigned successfully.');
        return redirect()->back();
    }
    
    
    public function showDetails(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $customers = DB::table('customers')->orderBy('id', 'asc')->get();
        $statuses = DB::table('project_statuses')->orderBy('id', 'asc')->get();
        $users = DB::table('users')->where('role', 'user')->get();
        
        
        $contracts_manager = DB::table('users')->where('id', $project->contracts_manager)->first();
        $site_manager = DB::table('users')->where('id', $project->site_manager)->first();
        return view('project.details', ['customer' => $customer, 'project' => $project, 'customers'=>$customers, 'users'=>$users, 'site_manager'=>$site_manager, 'contracts_manager'=>$contracts_manager, 'statuses'=>$statuses]);
    }
    
    public function viewInvoice(Request $request, $id)
    {
        $invoice = DB::table('project_invoices')->where('id', $id)->first();
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $invoice->project_id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        
        $items = DB::table('project_invoice_items as a')
            ->leftjoin('project_financials as b', 'a.item_id', '=', 'b.id')
            ->select('a.*', 'b.*')
            ->where('a.invoice_id', $invoice->id)
            ->get();
        
        return view('project.invoice', ['invoice' => $invoice, 'project' => $project, 'customer'=>$customer, 'items'=>$items]);
    }
    
    public function getEmailBody(Request $request)
    {
        $email = DB::table('project_emails')->where('id', $request->email_id)->first();
        if($email){
            return $email->message;
        }else{
            return 'Email not found';
        }
    }
    
    
    public function getItemsDetails(Request $request)
    {
        $ids = $request->financial_ids;
        $idArray = explode(',', $ids);
        $items = DB::table('project_financials')
            ->whereIn('id', $idArray)
            ->get();
        return response()->json($items);
    }
    
    
    public function showFinancials(Request $request, $id)
    {
        $project = DB::table('projects as a')
            ->leftjoin('customers as b', 'a.customer_id', '=', 'b.id')
            ->leftjoin('project_statuses as c', 'a.project_status', '=', 'c.id')
            ->select('a.*', 'b.company_name', 'c.name as status')
            ->where('a.id', $id)
            ->first();
        $customer = DB::table('customers')->where('id', $project->customer_id)->first();
        $invoices = DB::table('project_invoices')->where('project_id', $id)->orderBy('id', 'desc')->get();
        
        $items = DB::table('project_financials as a')
            ->leftjoin('customers as b', 'a.supplier_id', '=', 'b.id')
            ->leftJoin('project_purchase_orders as c', 'a.purchase_order_id', '=', 'c.id')
            ->select('a.*', 'b.company_name as supplier', 'c.receipt_photo')
            ->where('a.project_id', $id)
            ->get();
        
        $f_items = DB::table('financial_items')->get();
        $suppliers = DB::table('customers')->where('type', 'supplier')->get();
        $uoms = DB::table('financial_uoms')->orderBy('id', 'asc')->get();
        
        return view('project.financials', ['customer' => $customer, 'project' => $project, 'items'=>$items, 'uoms'=>$uoms, 'f_items'=>$f_items, 'suppliers'=>$suppliers, 'invoices'=>$invoices]);
    }
    
    
    public function updateEndCustomer(Request $request, $id)
    {
        $response = array();
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'end_customer_name'   =>   $request->name,
                    'end_customer_phone'   =>   $request->phone,
                    'end_customer_email'   =>   $request->email,
                    'end_customer_address'   =>   $request->address,
             )
        );
        
        $request->session()->flash('success', 'End customer updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateFinancial(Request $request, $id)
    {
        $response = array();
        $items = $request->item_id;
        $i = 0;
        foreach($items as $item){
            DB::table('project_financials')
                ->where('id', $item)
                ->update(
                 array(
                        'description'   =>   $request->description[$i],
                        'quantity'   =>   $request->quantity[$i],
                        'sales_price'   =>   $request->sales_price[$i],
                        'estimated_price'   =>   $request->estimated_price[$i],
                        'supplier_id'   =>   empty($request->supplier[$i])?0:$request->supplier[$i],
                        'uom'   =>   empty($request->uom[$i])?0:$request->uom[$i],
                 )
            );
            $i++;
        }
        
        $request->session()->flash('success', 'Updated successfully.');
        return redirect()->back();
    }
    
    public function updateStatus(Request $request, $id)
    {
        $response = array();
        
        $project = DB::table('projects')->where('id', $id)->first();
        $status = DB::table('project_statuses')->where('id', $request->status_id)->first();
        
        
        DB::table('project_status_history')
            ->where('project_id', $id)
            ->where('status_id', $project->project_status)
            ->update(
             array(
                    'completed_on'   =>   date('Y-m-d H:i'),
                    'completed_by'   =>   Auth::id(),
             )
        );
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'project_status'   =>   $request->status_id,
             )
        );
        
        DB::table('project_status_history')
            ->insert(
             array(
                    'project_id'   =>   $id,
                    'status_id'   =>   $request->status_id,
                    'start_date'   =>   date('Y-m-d H:i'),
                    'end_date'   =>   Carbon::now()->addDays($status->completion_days)->toDateString(),
             )
        );
        
        
        
        $request->session()->flash('success', 'Status updated successfully.');
        return redirect()->back();
    }
    
    
    
    public function sendInvoice(Request $request)
    {
        DB::table('project_invoices')->where('id', $request->invoice_id)->update(
             array(
                    'sent_to_client'   =>   1,
                    'status'   =>   'printed',
             )
        );
        $request->session()->flash('success', 'Invoice send to client successfully.');
        return redirect()->back();
    }
    
    public function deleteInvoice(Request $request)
    {
       
        DB::table('project_financials')->where('invoice_id', $request->invoice_id)->update(
             array(
                    'invoiced'   =>   0,
                    'invoice_id'   =>   0,
             )
        );
        
        DB::table('project_invoices')->where('id', $request->invoice_id)->delete();
        $request->session()->flash('success', 'Invoice removed successfully.');
        return redirect()->back();
    }
    
    
    public function createPurchaseOrder(Request $request, $id)
    {
        $request->validate([
            'receipt_photo' => 'required|mimes:jpeg,png,jpg,gif|max:3072',
            'po_items' => 'required|array',
        ]);

        if ($request->hasFile('receipt_photo')) {
            $file = $request->file('receipt_photo');
            $ext = $file->getClientOriginalExtension();
            $filename = uniqid(time()) . '.' . $ext;
            $name = $file->getClientOriginalName();
            $file->move(public_path('img/purchase_orders'), $filename);
        }
        $response = array();
        
        $project = DB::table('projects')->where('id', $id)->first();
        //$idArray = explode(',', $request->po_items);
        
        $po_id = DB::table('project_purchase_orders')
            ->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'customer_id'   =>   $project->customer_id,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'amount'   =>   $request->amount,
                    'supplier_id'   =>   $request->supplier_id,
                    'description'   =>   $request->description,
                    'receipt_photo'   =>   $filename,
             )
        );
        
        foreach($request->po_items as $itemid){
            DB::table('purchase_order_items')
                ->insertGetId(
                 array(
                        'po_id'   =>   $po_id,
                        'item_id'   =>   $itemid,
                 )
            );
            
            DB::table('project_financials')->where('id', $itemid)->update(
                 array(
                        'purchased'   =>   1,
                        'purchase_order_id'   =>   $po_id,
                 )
            );
        }
        
        
        
        $request->session()->flash('success', 'Purchase order generated successfully.');
        return redirect()->back();
    }
    
    
    public function createInvoice(Request $request, $id)
    {
        $response = array();
        
        $project = DB::table('projects')->where('id', $id)->first();
        $idArray = explode(',', $request->item_ids);
        $notes = $request->notes;
        $hide_items = isset($request->show_items) ? 0 : 1;

        // Use the query builder to perform the query
        $sumEstimatedPrice = DB::table('project_financials')
            ->whereIn('id', $idArray)
            ->sum(DB::raw('sales_price * quantity'));
        
        $invoiceid = DB::table('project_invoices')
            ->insertGetId(
             array(
                    'project_id'   =>   $id,
                    'customer_id'   =>   $project->customer_id,
                    'created_at'   =>   date('Y-m-d H:i'),
                    'final_amount'   =>   $sumEstimatedPrice,
                    'notes'   =>   $notes,
                    'hide_items'   =>   $hide_items,
             )
        );
        
        foreach($idArray as $itemid){
            DB::table('project_invoice_items')
                ->insertGetId(
                 array(
                        'project_id'   =>   $id,
                        'invoice_id'   =>   $invoiceid,
                        'item_id'   =>   $itemid,
                 )
            );
            
            DB::table('project_financials')->where('id', $itemid)->update(
                 array(
                        'invoiced'   =>   1,
                        'invoice_id'   =>   $invoiceid,
                 )
            );
        }
        
        
        
        $request->session()->flash('success', 'Invoice created successfully.');
        return redirect()->back();
    }
    
    
    public function updateCustomer(Request $request, $id)
    {
        $response = array();
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'customer_name'   =>   $request->name,
                    'customer_phone'   =>   $request->phone,
                    'customer_email'   =>   $request->email,
                    'customer_ref'   =>   $request->customer_ref,
                    'customer_id'   =>   $request->customer_id,
             )
        );
        
        $request->session()->flash('success', 'Customer updated successfully.');
        return redirect()->back();
    }
    
    
    public function updateLocation(Request $request, $id)
    {
        $response = array();
        
        $this->validate($request, [
            'location'   =>   'required|string',
        ]);
        
        DB::table('projects')
            ->where('id', $id)
            ->update(
             array(
                    'location'   =>   $request->location,
             )
        );
        
        $request->session()->flash('success', 'Project location updated successfully.');
        return redirect()->back();
    }
	
    
    public function getEmails()
    {
        try {
            $client = Client::account('gmail'); // Use the 'gmail' account configured in imap.php
            $client->connect(); // Connect to the account

            $emails = [];

            // Get all mailboxes
            $folders = $client->getFolders();

            foreach ($folders as $folder) {
                // Get all messages of the current mailbox
                $messages = $folder->messages()->all()->get();

                foreach ($messages as $message) {
                    $emails[] = [
                        'subject' => $message->getSubject(),
                        'date' => $message->getDate()->format('Y-m-d H:i:s'),
                        'attachments' => $message->getAttachments()->count(),
                        'body' => $message->getHTMLBody(),
                    ];
                }
            }

            return view('emails.index', compact('emails'));
        } catch (\Exception $e) {
            dd('Connection setup failed: ' . $e->getMessage());
        }
    }



}